// // // // // // // // // // // // // // // //
//
//	Enemy Territory - ServerWelt.cc
//
//	erstellt 1.2.98 Andreas Warnke
//	geändert 10.5.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "ServerWelt.h"
#include "Spieler.h"
#include "AsciiKette.h"
#include "PortMeter.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

ServerWelt :: ServerWelt ( unsigned int inMapSize )
	: Communicator ( inMapSize )
{
	//	Spieler-Liste:
	//	Spieler-IDs werden ab 2 vergeben:
	//	0 = gehört niemand.
	//	1 = gehört Natives.
	NextSpielerID = 2;
	
	//	zunächst gibts keinen Gewinner.
	DerGewinner = 0;
	
	//	CheckBusyList() wurde nicht abgebrochen:
	CheckBusyListAt = 0;
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

ServerWelt :: ~ServerWelt ()
{
};



// // // // // // // // // // // // // // // //
//
//	FindClient
//

Spieler * ServerWelt :: FindClient ( const char * inName, int inIndex )
{
	unsigned int i = SpielerListe . CountElements ();
	while ( i > 0 )
	{
		i--;
		Spieler * Test = ((Spieler*) SpielerListe . GetElement ( i ) );
		if ( Equal ( inName, Test -> DerName ) )
		{
			//	passt:
			if ( inIndex == 0 )
				return Test;
			inIndex--;
		};
	};
	return NULL;
};



// // // // // // // // // // // // //
//
//	OneWorldAddLine:
//

void ServerWelt :: OneWorldAddLine ( int inX, int inY, uint8 * ioBitFeld )
{
	//	sBitFeldBreite;
	int sBitFeldBreite = ( Karte :: Width + 7 ) / 8;
	
	//	Parametercheck:
	if ( ioBitFeld == NULL )
		return;
	if ( GetFieldDelay ( inX, inY ) >= FD_NoWay )
		return;
	if ( ( ( ioBitFeld [ ( inX >> 3 ) + inY * sBitFeldBreite ] >> ( inX & 7 ) ) & 1 ) == 1 )
		//	schon kontrolliert.
		return;
		
	//	markiere Feld:
	ioBitFeld [ ( inX >> 3 ) + inY * sBitFeldBreite ]
		= ioBitFeld [ ( inX >> 3 ) + inY * sBitFeldBreite ]
		| ( 1 << ( inX & 7 ) );
		
	//	laufe nach links und markiere:
	int sXLeft = inX;
	while ( GetFieldDelay ( sXLeft - 1, inY ) < FD_NoWay )
	{
		sXLeft --;
		ioBitFeld [ ( sXLeft >> 3 ) + inY * sBitFeldBreite ]
			= ioBitFeld [ ( sXLeft >> 3 ) + inY * sBitFeldBreite ]
			| ( 1 << ( sXLeft & 7 ) );
	};
	
	//	laufe nach rechts und markiere:
	while ( GetFieldDelay ( inX + 1, inY ) < FD_NoWay )
	{
		inX ++;
		ioBitFeld [ ( inX >> 3 ) + inY * sBitFeldBreite ]
			= ioBitFeld [ ( inX >> 3 ) + inY * sBitFeldBreite ]
			| ( 1 << ( inX & 7 ) );
	};
	
	//	laufe von links nach rechts, rufe rekursion auf:
	do
	{
		OneWorldAddLine ( sXLeft - 1 + IsShiftRight ( inY ), inY - 1, ioBitFeld );
		OneWorldAddLine ( sXLeft - 1 + IsShiftRight ( inY ), inY + 1, ioBitFeld );
		sXLeft ++;
	}
	while ( ( sXLeft - 1 ) <= inX );
};



// // // // // // // // // // // // //
//
//	OneWorld:
//

bool ServerWelt :: OneWorld ()
{
	//	Bit-Feld allokieren:
	uint8 * sBitFeld;
	int sBitFeldBreite = ( Karte :: Width + 7 ) / 8;
	sBitFeld = new uint8 [ sBitFeldBreite * Karte :: Height ];

	if ( sBitFeld == NULL )
		//	 Out of Memory.
		return false;	
		
	//	Bit-Feld initialisieren:
	int sX;
	int sY;
	for ( sX = 0; sX < sBitFeldBreite; sX ++ )
		for ( sY = 0; sY < Karte :: Width; sY ++ )
			sBitFeld [ sX + sY * sBitFeldBreite ] = 0;
	
	//	ein begehbares Feld suchen:
	int sStartX = 0;
	int sStartY = 0;
	while ( GetFieldDelay ( sStartX, sStartY ) >= FD_NoWay )
	{
		sStartX ++;
		if ( sStartX >= Karte :: Height )
		{
			sStartX = 0;
			sStartY ++;
			if ( sStartY >= Karte :: Width )
			{
				//	Keine begehbaren Felder:
				delete [] sBitFeld;
				return true;
			};
		};
	};
	
	//	Rekursion starten:
	OneWorldAddLine ( sStartX, sStartY, sBitFeld );

	//	Prüfe, ob alle Felder gefunden wurden:
	for ( sX = 0; sX < Karte :: Width; sX ++ )
		for ( sY = 0; sY < Karte :: Height; sY ++ )
			if ( ( GetFieldDelay ( sX, sY ) < FD_NoWay )
				&& ( ( ( sBitFeld [ ( sX >> 3 ) + sY * sBitFeldBreite ] >> ( sX & 7 ) ) & 1 ) == 0 ) )
			{
				delete [] sBitFeld;
				return false;
			};		

	//	speicher freigeben:
	delete [] sBitFeld;
	return true;
};



// // // // // // // // // // // // //
//
//	GrowStructure:
//

void GrowStructure_MakeMove (
	int inX, int inY,
	int inDir,
	int & outX, int & outY );

void GrowStructure_MakeMove (
	int inX, int inY,
	int inDir,
	int & outX, int & outY )
{
	switch ( inDir % 6 )
	{
	case 0:	//	1 h
		outY = inY - 1;
		outX = inX + Karte :: IsShiftRight ( inY );
		break;
	case 1:	//	3 h
		outX = inX + 1;
		outY = inY;
		break;
	case 2:	//	5 h
		outY = inY + 1;
		outX = inX + Karte :: IsShiftRight ( inY );
		break;
	case 3:	//	7 h
		outY = inY + 1;
		outX = inX - 1 + Karte :: IsShiftRight ( inY );
		break;
	case 4:	//	9 h
		outX = inX - 1;
		outY = inY;
		break;
	case 5:	//	11 h
		outY = inY - 1;
		outX = inX - 1 + Karte :: IsShiftRight ( inY );
		break;
	};
};

void ServerWelt :: GrowStructure (
	int inX, int inY,
	int inTyp, int inVariations,
	int inCount )
{
	//	Setze inMaxCount Felder:
	while ( inCount > 0 )
	{
		inCount --;
		
		//	Suche Position für ein Feld:
		int sX = inX;
		int sY = inY;
		int sTimeOut = 0x100;
		int sCurrentFT = GetFieldType ( sX, sY );
		int sDirection = Fate . GetLong ( 6 );
		while ( ( sCurrentFT >= inTyp ) && ( sCurrentFT < inTyp + inVariations )
			&&	( sTimeOut > 0 ))
		{
			sTimeOut --;
			
			//	Richtung ändern:
			if ( Fate . GetLong ( 2 ) == 0 )
			{
				// leichte Drehung:
				sDirection = sDirection + Fate . GetLong ( 3 ) - 1;
				if ( sDirection < 0 )
					sDirection = 5;
				if ( sDirection >= 6 )
					sDirection = 0;
			};
			
			//	Move:
			GrowStructure_MakeMove ( sX, sY, sDirection, sX, sY );
			
			sCurrentFT = GetFieldType ( sX, sY );
		};
		
		//	Neue Position gefunden.
		//	Änderung:
		int sOldType = GetFieldType ( sX, sY );
		bigtime_t sOldDelay = GetFieldDelay ( sX, sY );
		SetFieldType ( sX, sY, inTyp + Fate . GetLong ( inVariations ) );
		if ( ( GetFieldDelay ( sX, sY ) >= FD_NoWay ) ^ ( sOldDelay >= FD_NoWay ) )
		{
			//	evtl. wude die Welt geteilt.
			//	Bestimme, ob durch das aktuelle Feld
			//	mehrere Seen verbunden werden:
			int sCheckChanges = 0;
			bool sCheckLastLand;
			for ( int sCheckDir = 0; sCheckDir <= 6; sCheckDir ++ )
			{
				int sCheckX;
				int sCheckY;
				GrowStructure_MakeMove ( sX, sY, sCheckDir, sCheckX, sCheckY );
				if ( GetFieldDelay ( sCheckX, sCheckY ) < FD_NoWay )
				{
					//	Hier ist Land!
					if ( sCheckDir != 0 )
						if ( ! sCheckLastLand )
							sCheckChanges ++;
					sCheckLastLand = true;
				}
				else
				{
					//	Hier ist Wasser!
					if ( sCheckDir != 0 )
						if ( sCheckLastLand )
							sCheckChanges ++;
					sCheckLastLand = false;
				};
			};
			
			if ( sCheckChanges > 3 )
				/*if ( Fate . GetLong ( 8 ) == 0 )
					//	Es ist unwahrscheinlich, aber möglich,
					//	daß Seen miteinander verbunden werden.
					if ( ! OneWorld () )
						//	Fehler: Zwei Welten.
						SetFieldType ( sX, sY, sOldType );
					else {}
				else*/
					SetFieldType ( sX, sY, sOldType );
		};
	};
};



// // // // // // // // // // // // //
//
//	InitMap:
//

void ServerWelt :: InitMap ()
{
	//	Variablen:
	int sX, sY;

	//	Felder mit Plain initialisieren: 		
	for ( sX = Karte :: Width - 1; sX >= 0; sX-- )
		for ( sY = Karte :: Height - 1; sY >= 0; sY-- )
			Karte :: SetFieldType ( sX, sY, FT_Plain + Fate . GetLong ( FI_Plain ) );
	
	//	Wald verteilen:
	int sGrobOderFein = Fate . GetLong ( 16 ) + 2;
	for ( sX = Karte :: Width - 1; sX >= 0; sX-- )
		for ( sY = Karte :: Height - 1; sY >= 0; sY-- )
			if ( Fate . GetLong ( sGrobOderFein + 1 ) == 0 )
				GrowStructure ( sX, sY, FT_Forrest, FI_Forrest, Fate . GetLong ( sGrobOderFein ) + 1 );
				
	//	Seen verteilen:
	int sSumpf = Fate . GetLong ( 16 ) + 10;	//	10 = Sumpf, 25 = trocken
	for ( sX = Karte :: Width - 1; sX >= 0; sX-- )
		for ( sY = Karte :: Height - 1; sY >= 0; sY-- )
			if ( Fate . GetLong ( sSumpf ) == 0 )
				GrowStructure ( sX, sY, FT_Sea, FI_Sea, Fate . GetLong ( 5 ) * Fate . GetLong ( 5 ) + 1 );
				
	//	Berge verteilen:
	for ( sX = Karte :: Width - 1; sX >= 0; sX-- )
		for ( sY = Karte :: Height - 1; sY >= 0; sY-- )
			if ( GetFieldDelay ( sX, sY ) < FD_NoWay )
				if ( Fate . GetLong ( 64 ) == 0 )
					GrowStructure ( sX, sY, FT_Mountain, FI_Mountain, Fate . GetLong ( 12 ) + 1 );
					
	//	verteile Eingeborenen-Dörfer:
	/*for ( sX = Karte :: Width - 1; sX >= 0; sX-- )
		for ( sY = Karte :: Height - 1; sY >= 0; sY-- )
			if ( GetFieldDelay ( sX, sY ) < FD_NoWay )
				if ( Fate . GetLong ( 128 ) == 0 )
				{
					//	Erstelle neues Objekt:
					Objekt * sDieCity = new Objekt ( Obj_Dorf, 1, sX, sY);
									
					//	Stadt in Objektliste einfügen:
					if ( sDieCity != NULL )
					{
						#if eNativesGetArmies
							//	100 ms, damit anschließendes Insert
							//	die City garantiert in die BusyList einfügt.
							sDieCity -> BusyTill = real_time_clock_usecs () + 100000 + Fate . GetLong ( FD_CreateArmy );
						#endif
						if ( ! Insert( sDieCity ) )
							//	Nicht eingefügt
							delete sDieCity;
					};
				};*/
	int sRun = ( GetWidth () * GetHeight () ) / 80 ; //	max cities = 80 if max mapsize = 40
	while ( sRun > 0 )
	{
		sRun --;
		NeuerSpieler ( 1, 0, 1 );
	};
};



// // // // // // // // // // // // //
//
//	NeuerSpielerValidPlace:
//

/*bool ServerWelt :: NeuerSpielerValidPlace ( int & outX, int & outY )
{
	outY = 0;
	while ( outY < Karte :: Height )
	{
		outX = 0;
		while ( outX < Karte :: Width )
		{
			//	Gültiger Platz?
			if ( ( GetFieldDelay( outX, outY ) != FD_NoWay )
				&& ( CountObjects ( outX, outY ) == 0 ) )
				return true;
			
			outX ++;	
		};
		outY ++;
	};
	outX = -1;
	outY = -1;
	return false;
};*/



// // // // // // // // // // // // //
//
//	NeuerSpielerValidPlace2:
//

int ServerWelt :: NeuerSpielerValidPlace2 ( int inX, int inY )
{
	//	korrekte Parameter?
	if ( GetFieldDelay ( inX, inY ) >= FD_NoWay )
		return 0;
		
	//	Ist ein anderes Objekt sichtbar?
	int sVisX [37];
	int sVisY [37];
	int sVisCount;
	GetAllVisibleFields ( inX, inY, sVisX, sVisY, sVisCount );
	while ( sVisCount > 0 )
	{
		sVisCount --;
		if ( GetSpielerID ( sVisX [ sVisCount ], sVisY [ sVisCount ] ) != 0 )
			//	sichtbares Objekt.
			return 0;
	};
	
	//	Bestimme Entfernung ( Luftlinie ) zum nächsten Objekt:
	unsigned int sErg = -1;
	sErg = sErg >> 1;
	int sCount = ObjektListe . CountElements ();
	while ( sCount > 0 )
	{
		sCount --;
		Objekt * sFinger = (Objekt*) ObjektListe . GetElement ( sCount );
		int sThisErg = Distance ( sFinger -> XPos, sFinger -> YPos, inX, inY );
		if ( sErg > sThisErg )
			sErg = sThisErg;
	};
	
	//	Fertig:
	return sErg;
};



// // // // // // // // // // // // //
//
//	NeuerSpieler:
//

bool ServerWelt :: NeuerSpieler ( int inSpielerID, int inArmies, int inCities )
{
	//	Bestplace initialisieren:
	int sBestX = -1;
	int sBestY = -1;
	unsigned int sBestValue = 0;
	int sMitteX = Karte :: Width / 2;
	int sMitteY = Karte :: Height / 2;
	
	//	Zufällig Startplätze suchen:
	for ( int i = 0; i < 64; i++ )
	{
		int sTestX = Fate . GetLong ( Karte :: Width );
		int sTestY = Fate . GetLong ( Karte :: Height );
		int sTestValue = NeuerSpielerValidPlace2 ( sTestX, sTestY );
		if ( ( sTestValue > sBestValue )
			|| ( ( sTestValue == sBestValue )
			&& ( Distance ( sTestX, sTestY, sMitteX, sMitteY )
			> Distance ( sBestX, sBestY, sMitteX, sMitteY ) ) ) )
		{
			//	Besserer Platz gefunden.
			sBestX = sTestX;
			sBestY = sTestY;
			sBestValue = sTestValue;
		};
	};
	
	//	Falls kein Startplatz:
	//	Alle Startplätze ausprobieren:
	if ( sBestValue == 0 )
		for ( int sX = 0; sX < Karte :: Width; sX++ )
			for ( int sY = 0; sY < Karte :: Width; sY++ )
			{
				int sTestValue2 = NeuerSpielerValidPlace2 ( sX, sY );
				if ( sTestValue2 > sBestValue )
				{
					//	Besserer Platz gefunden.
					sBestX = sX;
					sBestY = sY;
					sBestValue = sTestValue2;
				};	
			};			
	
	if ( sBestValue == 0 )
		return false;
	else
	{
		int Figuren = inArmies + inCities;
		while ( Figuren > 0 )
		{
			Figuren --;
			
			//	Figur erstellen:
			bigtime_t sBusyTill = 1;
			unsigned int sTyp = Obj_Dorf;
			if ( inArmies-- > 0 )
				//	Army.
				sTyp = Obj_Figur;
			else
				//	City.
				#if eNativesGetArmies
					sBusyTill = real_time_clock_usecs () + FD_CreateArmy + FD_BuildVillage;
				#else
					if ( inSpielerID > 1 )
						sBusyTill = real_time_clock_usecs () + FD_CreateArmy + FD_BuildVillage;
				#endif				
			Objekt * DieFigur = new 
				Objekt ( 
					sTyp,
					inSpielerID,
					sBestX,
					sBestY,
					sBusyTill );
					
			//	Figur in Objektliste einfügen:
			if ( DieFigur != NULL )
				if ( ! Insert( DieFigur ) )
				{
					//	Nicht eingefügt
					delete DieFigur;
				};
				
		};
		//	Spieler informieren:
		ReportChangedField ( sBestX, sBestY, inSpielerID );
		ReportMove ( 0, -1, sBestX, sBestY, inSpielerID );
		return true;
	};
};



// // // // // // // // // // // // //
//
//	NewArmy:
//

bool ServerWelt :: NewArmy ( Objekt * inDorf )
{
	if ( inDorf == NULL )
		//	error.
		return false;
		
	if ( inDorf -> Typ != Obj_Dorf )
		//	nur Cities können Armies erstellen.
		return false;
		
	bigtime_t sNow = real_time_clock_usecs();
	if ( inDorf -> BusyTill > sNow )
		//	Das Dorf ist noch beschaeftigt.
		return false;
		
	#if ( ! eNativesGetArmies )
		if ( inDorf -> BelongsTo == 1 )
			//	Natives bekommen keine Armeen:
			return false;
	#endif
	
	//	Nächste Armee:
	inDorf -> BusyTill = sNow + FD_CreateArmy;
	
	//	Figur erstellen:
	Objekt * DieFigur = new 
		Objekt ( 
			Obj_Figur,
			inDorf -> BelongsTo,
			inDorf -> XPos,
			inDorf -> YPos);
					
	//	Figur in Objektliste einfügen:
	if ( DieFigur == NULL )
		return false;
	
	if ( ! Insert( DieFigur ) )
	{
		//	Nicht eingefügt
		delete DieFigur;
		return false;
	};
				
	//	Spieler informieren:
	ReportChangedField ( inDorf -> XPos, inDorf -> YPos, inDorf -> BelongsTo );
	ReportMove ( -17, -17, inDorf -> XPos, inDorf -> YPos, inDorf -> BelongsTo );
	return true;
};



// // // // // // // // // // // // // // // //
//
//	ZweiKampf
//

void ServerWelt :: ZweiKampf ( int inX, int inY )
{
	//	gültige Parameter?
	if ( ( GetFieldType ( inX, inY ) == FT_EndOfWorld ) || ( ObjektFeld == NULL ) )
		return;
	
	//	Ermittlung der Daten:
	int sID1 = 0;
	int sID2 = 0;
	int sArmies1 = 0;
	int sArmies2 = 0;
	//	Durclaufe Objektliste
	//	bestimme, welche spieler wieviele armeen haben:
	ElementList * sObjekte = & ObjektFeld [ inX + Width * inY ];
	Objekt * sFinger;
	int i = sObjekte -> CountElements ();
	while ( i > 0 )
	{
		i--;
		sFinger = (Objekt*) sObjekte -> GetElement ( i );
		if ( sID1 == 0 )
			sID1 = sFinger -> BelongsTo;
		if ( ( sID2 == 0 )	&& ( sFinger -> BelongsTo != sID1 ) )
			sID2 = sFinger -> BelongsTo;
		if ( sFinger -> BelongsTo == sID1 )
			if ( sFinger -> Typ == Obj_Figur )
				sArmies1 ++;
		if ( sFinger -> BelongsTo == sID2 )
			if ( sFinger -> Typ == Obj_Figur )
				sArmies2 ++;
	};
	
	//	solange beide Spieler noch armeen haben, kämpfe:
	while ( ( sArmies1 > 0 ) && ( sArmies2 > 0 ) )
	{
		bool FirstIsLooser = ( Fate . GetLong ( 2 ) == 0 );
		
		//	lösche Armee:
		bool found = false;
		i = sObjekte -> CountElements ();
		while ( ( i > 0 ) && ( ! found ) )
		{
			i--;
			sFinger = (Objekt*) sObjekte -> GetElement ( i );
			if ( sFinger -> Typ == Obj_Figur )
				if ( FirstIsLooser )
					if ( sFinger -> BelongsTo == sID1 )
						found = true;
					else {}
				else
					if ( sFinger -> BelongsTo == sID2 )
						found = true;
		};
		if ( FirstIsLooser )
			sArmies1 --;
		else
			sArmies2 --;
		if ( found ) delete sFinger;
	};
	
	//	Alle Dörfer unterbrechen die Produktion und gehören dem Gewinner:
	i = sObjekte -> CountElements ();
	bigtime_t sNow = real_time_clock_usecs ();
	while ( i > 0 )
	{
		i--;
		sFinger = (Objekt*) sObjekte -> GetElement ( i );
		if ( sFinger -> Typ == Obj_Dorf )
		{
			//	Die gerade entstehenden Armeen werden zerstört:
			if ( sFinger -> BusyTill < sNow + FD_CreateArmy )
				sFinger -> BusyTill = sNow + FD_CreateArmy;
			//	Besitzer ist der Gewinner:
			if ( sArmies1 > 0 )
				sFinger -> BelongsTo = sID1;
			else /*if ( sArmies2 > 0 )*/
				sFinger -> BelongsTo = sID2;
			
			#if ( ! eNativesGetArmies )
				//	Falls das Dorf ursprünglich neutral war,
				//	muß es in die Busy-List aufgenommen werden:
				if ( ! BusyList . HasElement ( (Element*) sFinger ) )
				BusyList . Insert ( (Element*) sFinger );
			#endif
		};
	};
	
	//	Informiere den Looser und den Gewinner:
	if ( sArmies1 <= 0 )
	{
		ReportMove ( inX, inY, -17, -13, sID1 );
		ReportMove ( inX, inY, inX, inY, sID2 );
		ReportChangedField ( inX, inY, sID2 );
	};
	if ( sArmies2 <= 0 )
	{
		ReportMove ( inX, inY, -17, -13, sID2 );
		ReportMove ( inX, inY, inX, inY, sID1 );
		ReportChangedField ( inX, inY, sID1 );
	};
	
	//	Hat jemand das Spiel gewonnen?
	CheckForWinner ();
};



// // // // // // // // // // // // // // // //
//
//	MakeMove
//

void ServerWelt :: MakeMove ( Objekt* inObj )
{
	if ( inObj == NULL )
		//	error.
		return;
		
	if ( inObj -> Typ != Obj_Figur )
		//	nur Figuren können bewegt werden.
		return;
		
	//	Bestimme aktuelle Uhrzeit:
	bigtime_t sNow = real_time_clock_usecs ();
	if ( inObj -> BusyTill > sNow )
		//	Das Objekt ist noch beschaeftigt.
		//	Also auch in der Busy-List.
		return;
		
	//	jetzige Position merken:
	int sOldX = inObj -> XPos;
	int sOldY = inObj -> YPos;
	//	New position:
	int sNewX = inObj -> MoveToX;
	int sNewY = inObj -> MoveToY;
	
	bigtime_t sDelay = GetFieldDelay ( sNewX, sNewY );
	if ( sDelay >= FD_NoWay )
	{
		//	Dort kann man nicht hinlaufen
		inObj -> MoveToX = sOldX;
		inObj -> MoveToY = sOldY;
		return;
	};
		
	if ( Distance( sOldX, sOldY, sNewX, sNewY ) != 1 )
	{
		//	illegal move
		inObj -> MoveToX = sOldX;
		inObj -> MoveToY = sOldY;
		return;
	};
	
	//	Bestimme, welcher Spieler zuerst auf neuem Feld war:
	int sZuerstID = GetSpielerID ( inObj -> MoveToX, inObj -> MoveToY );
		
	//	bewege das Objekt zum Ziel:
	/*DeleteID ( inObj -> GetID (), false );
	inObj -> XPos = sNewX;
	inObj -> YPos = sNewY;
	inObj -> BusyTill = sNow + sDelay;
	if ( ! Insert ( inObj ) )
	{
		//	out of memory.
		ReportChangedField ( sOldX, sOldY );
		// delete inObj;	//	kein Delete, da mit diesem Objekt noch gearb eitet wird.
		return;
	};*/
	inObj -> BusyTill = sNow + sDelay;
	if ( ! MoveObjectTo ( inObj ) )
		return;
	
	//	informiere Clients über move:
	ReportChangedField ( sOldX, sOldY, inObj -> BelongsTo );
	ReportChangedField ( sNewX, sNewY, inObj -> BelongsTo );
	ReportMove ( sOldX, sOldY, sNewX, sNewY, inObj -> BelongsTo );

	if ( ( sZuerstID != 0 ) && ( sZuerstID != inObj -> BelongsTo ) )
	{
		//	Kampf.
		ZweiKampf ( sNewX, sNewY );
	};
};



// // // // // // // // // // // // // // // //
//
//	BuildVillage
//

void ServerWelt :: BuildVillage ( Objekt* inObj )
{
	if ( inObj == NULL )
		//	error.
		return;
		
	if ( inObj -> Typ != Obj_Figur )
		//	nur Figuren können zu Dörfern werden.
		return;
		
	//	inObj in Dorf umwandeln:
	inObj -> MoveToX = inObj -> XPos;
	inObj -> MoveToY = inObj -> YPos;
	inObj -> Typ = Obj_Dorf;		
	bigtime_t sNow = real_time_clock_usecs();				
	if ( inObj -> BusyTill > sNow )
		inObj -> BusyTill = inObj -> BusyTill + FD_BuildVillage + FD_CreateArmy;
	else
		inObj -> BusyTill = sNow + FD_BuildVillage + FD_CreateArmy;						
	
	//	füge inObj in Busy-List ein:
	if ( ! ( BusyList . HasElement ( (Element*) inObj ) ) )
		BusyList . Insert ( (Element*) inObj );
	
	//	informiere Clients über build:
	ReportChangedField ( inObj -> XPos, inObj -> YPos );
};



// // // // // // // // // // // // // // // //
//
//	GetNextSpielerID
//

unsigned int ServerWelt :: GetNextSpielerID ()
{
	return NextSpielerID++;
};



// // // // // // // // // // // // // // // //
//
//	CheckBusyList:
//
//	returns true, if there was enough time to
//	evaluate the whole list.
//

bool ServerWelt :: CheckBusyList ()
{
	//	TimeOut initialization
	enum { eCheckFiguresTillNextTest = 15 };
	enum { eMaxWaitingMessages = 5 };
	int sTimeOut = eCheckFiguresTillNextTest;
	
	bigtime_t sNow = real_time_clock_usecs ();
	int sElementsTillReady = BusyList . CountElements ();
	if ( CheckBusyListAt >= BusyList . CountElements () )
		CheckBusyListAt = 0;
	//	For every Object in the list do:
	while ( ( sElementsTillReady > 0 ) && ( sTimeOut > 0 ) )
	{	
		sElementsTillReady --;

		//	Evaluate new check position:
		CheckBusyListAt --;
		if ( CheckBusyListAt < 0 )
			CheckBusyListAt = BusyList . CountElements () - 1;
		
		//	Get Element at Check-Position:
		Objekt * Found = (Objekt*) ( BusyList . GetElement ( CheckBusyListAt ) );
		
		if ( Found -> BusyTill < sNow )
		{
			//	Hier ist einer grad fertiggeworden.
			if ( Found -> Typ == Obj_Figur )
				//	Wie süß! Es ist eine armee!
				if (( Found -> MoveToX != Found -> XPos )
					|| ( Found -> MoveToY != Found -> YPos ))
					//	Neuer Auftrag.
					MakeMove ( Found );
				else
				{
					//	There is no next step.
				}
			else if ( Found -> Typ == Obj_Dorf )
				//	Wie süß! Es ist ein Dorf!
				NewArmy ( Found );
				
			//	Check for Timeout:
			sTimeOut --;
			if ( sTimeOut <= 0 )
				if ( PortMeter :: CountAllWaitingMessages ( be_app -> Team () ) < eMaxWaitingMessages )
					//	There is still time to evaluate some more elements:
					sTimeOut = eCheckFiguresTillNextTest;
		};
		if ( Found -> BusyTill < sNow )
		{
			//	Hier ist einer grad fertiggeworden, der keinen weiteren
			//	Auftrag hat.
			BusyList . Remove ( (Element*) Found );
			ReportChangedField ( Found -> XPos, Found -> YPos );
		};
	};
	
	//	fertig:
	return ( sElementsTillReady == 0 );
};



// // // // // // // // // // // // // // // //
//
//	CheckForWinner:
//

void ServerWelt :: CheckForWinner ()
{
	if ( NextSpielerID <= 3 )
		//	Es waren noch nie 2 Spieler eingelogged.
		return;

	//	Ermittle, ob nur noch ein Spieler vorhanden:
	unsigned int sWinner = 0;
	int sRun = ObjektListe . CountElements ();
	while ( sRun > 0 )
	{
		sRun --;
		Objekt * sFinger = (Objekt*) ObjektListe . GetElement ( sRun );
		if ( sFinger -> BelongsTo > 1 )
			if ( sWinner == 0 )
				sWinner = sFinger -> BelongsTo;
			else if ( sWinner != sFinger -> BelongsTo )
				return;
	};
	
	//	=> gewonnen.
	DerGewinner = sWinner;
};



// // // // // // // // // // // // // // // //
//
//	GetWinner:
//

unsigned int ServerWelt :: GetWinner ()
{
	return DerGewinner;
};



// // // // // // // // // // // // // // // //
//
//	SpielerName:
//

const char * ServerWelt :: SpielerName ( unsigned int inID )
{
	int sCurPos = SpielerListe . CountElements ();
	while ( sCurPos > 0 )
	{
		sCurPos --;
		Spieler * sFinger = (Spieler*) SpielerListe . GetElement ( sCurPos );
		if ( sFinger -> DieID == inID )
			return sFinger -> DerName;
	};
	return NULL;
};



//
//	Ende
//
// // // // // // // // // // // // // // // //